/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.craftpresence.config.gui;

import com.gitlab.cdagaming.craftpresence.CraftPresence;
import com.gitlab.cdagaming.craftpresence.config.gui.PresenceEditorGui;
import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.config.Config;
import com.gitlab.cdagaming.craftpresence.core.config.category.Biome;
import com.gitlab.cdagaming.craftpresence.core.config.element.ModuleData;
import com.gitlab.cdagaming.craftpresence.core.config.element.PresenceData;
import com.gitlab.cdagaming.craftpresence.utils.gui.controls.DynamicScrollableList;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.ConfigurationGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicEditorGui;
import com.gitlab.cdagaming.craftpresence.utils.gui.impl.DynamicSelectorGui;
import com.gitlab.cdagaming.unilib.utils.gui.controls.ExtendedButtonControl;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ExtendedScreen;
import com.gitlab.cdagaming.unilib.utils.gui.widgets.TextWidget;
import io.github.cdagaming.unicore.utils.StringUtils;
import net.minecraft.class_364;
import net.minecraft.class_437;

public class BiomeSettingsGui
extends ConfigurationGui<Biome> {
    private final Biome INSTANCE;
    private final Biome DEFAULTS = this.getCurrentData().getDefaults();
    private ExtendedButtonControl biomeMessagesButton;
    private TextWidget defaultMessage;
    private TextWidget defaultIcon;

    BiomeSettingsGui() {
        super(Constants.TRANSLATOR.translate("gui.config.title", new Object[0]), Constants.TRANSLATOR.translate("gui.config.title.biome_messages", new Object[0]));
        this.INSTANCE = this.getCurrentData().copy();
    }

    @Override
    protected void appendControls() {
        super.appendControls();
        ModuleData defaultData = this.getInstanceData().biomeData.get("default");
        String defaultBiomeMessage = Config.getProperty(defaultData, "textOverride") != null ? defaultData.getTextOverride() : "";
        this.defaultMessage = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(0), 180, 20, () -> {
            ModuleData defaultBiomeData = this.getInstanceData().biomeData.getOrDefault("default", new ModuleData());
            defaultBiomeData.setTextOverride(this.defaultMessage.getControlMessage());
            this.getInstanceData().biomeData.put("default", defaultBiomeData);
        }, Constants.TRANSLATOR.translate("gui.config.message.default.biome", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})))));
        this.defaultMessage.setControlMessage(defaultBiomeMessage);
        this.defaultIcon = (TextWidget)this.childFrame.addControl((class_364)new TextWidget(this.getFontRenderer(), this.getButtonY(1), 147, 20, () -> {
            this.getInstanceData().fallbackBiomeIcon = this.defaultIcon.getControlMessage();
        }, Constants.TRANSLATOR.translate("gui.config.name.biome_messages.biome_icon", new Object[0]), () -> this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_icon", new Object[0])))));
        this.addIconSelector((ExtendedScreen)this.childFrame, () -> this.defaultIcon, (attributeName, currentValue) -> {
            this.getInstanceData().fallbackBiomeIcon = currentValue;
        });
        this.defaultIcon.setControlMessage(this.getInstanceData().fallbackBiomeIcon);
        this.biomeMessagesButton = (ExtendedButtonControl)this.childFrame.addControl((class_364)new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getButtonY(2), 180, 20, Constants.TRANSLATOR.translate("gui.config.name.biome_messages.biome_messages", new Object[0]), () -> this.openScreen((ExtendedScreen)new DynamicSelectorGui(Constants.TRANSLATOR.translate("gui.config.title.selector.biome", new Object[0]), CraftPresence.BIOMES.BIOME_NAMES, null, null, true, true, DynamicScrollableList.RenderType.None, (attributeName, currentValue) -> {
            ModuleData defaultBiomeData = this.getInstanceData().biomeData.get("default");
            ModuleData currentBiomeData = this.getInstanceData().biomeData.get(attributeName);
            String defaultMessage = Config.getProperty(defaultBiomeData, "textOverride") != null ? defaultBiomeData.getTextOverride() : "";
            String currentMessage = Config.getProperty(currentBiomeData, "textOverride") != null ? currentBiomeData.getTextOverride() : "";
            ModuleData newData = new ModuleData();
            if (StringUtils.isNullOrEmpty((String)currentMessage) || currentMessage.equals(defaultMessage)) {
                newData.setTextOverride(defaultMessage);
            }
            newData.setIconOverride((String)currentValue);
            this.getInstanceData().biomeData.put((String)attributeName, newData);
        }, (currentValue, parentScreen) -> this.openScreen(new DynamicEditorGui((String)currentValue, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().biomeData.get("default");
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = screenInstance.originalPrimaryMessage;
        }, (attributeName, screenInstance) -> {
            screenInstance.defaultData = this.getInstanceData().biomeData.get("default");
            screenInstance.currentData = this.getInstanceData().biomeData.get(attributeName);
            screenInstance.isPreliminaryData = screenInstance.currentData == null;
            screenInstance.setScreenTitle(Constants.TRANSLATOR.translate("gui.config.title.biome.edit_specific_biome", new Object[]{attributeName}));
            screenInstance.originalPrimaryMessage = Config.getProperty(screenInstance.defaultData, "textOverride") != null ? screenInstance.defaultData.getTextOverride() : "";
            screenInstance.primaryMessage = Config.getProperty(screenInstance.currentData, "textOverride") != null ? screenInstance.currentData.getTextOverride() : screenInstance.originalPrimaryMessage;
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            String inputText = screenInstance.getPrimaryEntry();
            screenInstance.currentData.setTextOverride(inputText);
            this.getInstanceData().biomeData.put(attributeName, screenInstance.currentData);
            if (!CraftPresence.BIOMES.BIOME_NAMES.contains(attributeName)) {
                CraftPresence.BIOMES.BIOME_NAMES.add(attributeName);
            }
        }, screenInstance -> {
            String attributeName = screenInstance.getSecondaryEntry();
            this.getInstanceData().biomeData.remove(attributeName);
            if (!CraftPresence.BIOMES.DEFAULT_NAMES.contains(attributeName)) {
                CraftPresence.BIOMES.BIOME_NAMES.remove(attributeName);
            }
        }, (attributeName, screenInstance) -> {
            if (screenInstance.isPresenceButton) {
                PresenceData defaultPresenceData = Config.getProperty(screenInstance.defaultData, "data") != null ? screenInstance.defaultData.getData() : new PresenceData();
                PresenceData currentPresenceData = Config.getProperty(screenInstance.currentData, "data") != null ? screenInstance.currentData.getData() : defaultPresenceData;
                screenInstance.openScreen(new PresenceEditorGui(currentPresenceData, defaultPresenceData, output -> screenInstance.currentData.setData((PresenceData)output)));
            } else {
                screenInstance.currentData.setIconOverride((String)attributeName);
            }
        }, (attributeName, screenInstance) -> screenInstance.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})))), (class_437)parentScreen))), () -> {
            if (!this.biomeMessagesButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.access", new Object[]{Constants.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0])})));
            } else {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", new Object[]{CraftPresence.CLIENT.generateArgumentMessage("biome.")})));
            }
        }, new String[0]));
        this.proceedButton.setOnHover(() -> {
            if (!this.proceedButton.isControlEnabled()) {
                this.drawMultiLineString(StringUtils.splitTextByNewLine((String)Constants.TRANSLATOR.translate("gui.config.message.hover.empty.default", new Object[0])));
            }
        });
    }

    @Override
    protected boolean allowedToReset() {
        return true;
    }

    @Override
    protected void syncRenderStates() {
        super.syncRenderStates();
        this.proceedButton.setControlEnabled(!StringUtils.isNullOrEmpty((String)this.defaultMessage.getControlMessage()));
        this.biomeMessagesButton.setControlEnabled(CraftPresence.BIOMES.isEnabled());
    }

    @Override
    protected Biome getInstanceData() {
        return this.INSTANCE;
    }

    @Override
    protected Biome getCurrentData() {
        return CraftPresence.CONFIG.biomeSettings;
    }

    @Override
    protected Biome getDefaultData() {
        return this.DEFAULTS;
    }
}

